%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                         %
% Avnonin 1964  - Radial flow                                             %
%                                                                         %
% Version July 2013           Nelson Molina-Giraldo Matrix Solutions Inc. %
%                                                                         %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function T = T_avd_radial(r,z,h,lm,lm2,Cw,Cm,Cm2,vT,t,Q,ax)
%--Analytical solution----------------------------------------------------%
tao = 4*lm2*t/h^2/Cm; 
ke = lm2/lm2;
a = sqrt(lm2*Cm/lm/Cm2);
psi = Q*Cw/4/pi/h/lm;
rm = 2*r/h;

T = (1/gamma(psi))*(rm^2/4/ke/tao)^psi*quadgk(@(y) (1./y.^(psi+1)).*...
    exp(-rm^2/4/ke/tao./y).*...
    erfc(sqrt(tao/ke)*y/2/a./sqrt(1-y)),0,1);
  
%--Nomenclature-----------------------------------------------------------%
% r : radial coordinate [m]
% h : aqufer thickness [m]
% uz : thickness of the overlaying layer [m]
% k : bulk thermal conductivity of the aquifer [W/m/K]
% kd : bulk thermal conductivity of the overlaying layer [W/m/K]
% t : simulation time [s]
% vhcw : volumetric heat capacity of the water [J/m^3/K]
% vhcm : volumetric heat capacity of the porous medium (aquifer) [J/m^3/K]
% vhcmd : volumetric heat capacity of the porous medium (confining layers) [J/m^3/K]
% vT : heat transport velocity [m/s]
% ax: longitudinal thermal dispersivity
% Q : injection rate [m^3/s]